function T = build_drag_table(Mvec, CD0tot, base, inputs)
% BUILD_DRAG_TABLE  Genera tabla de arrastre D(M) (parásito/inducido/total).
% USO:
%   T = build_drag_table();                          % defaults
%   T = build_drag_table(Mvec, CD0tot, base, inputs) % normal

    % Defaults completos (hace el pipeline mínimo)
    if nargin < 1 || isempty(Mvec),  Mvec = (0.78:0.01:0.86)'; end
    if nargin < 4 || isempty(inputs)
        inputs = struct('S',992.8,'W',79600,'AR',7.51,'e',0.612);
    end
    if nargin < 3 || isempty(base)
        atm = isa_std_atmos(30000);
        base = base_quantities(atm, struct('S',inputs.S,'AR',inputs.AR,'e',inputs.e, ...
                        'TSFC_nom',0.60,'TSFC_bleed',0.608,'use_bleed',true));
    end
    if nargin < 2 || isempty(CD0tot)
        CD0tot = build_CD0_total(Mvec, 0.0055, 0.0);
    end

    Mvec = Mvec(:);
    CD0  = interp1(CD0tot.M(:), CD0tot.CD0(:), Mvec,'linear','extrap');

    q0S = base.q0S; k = base.k; W = inputs.W;
    M2   = Mvec.^2;
    CL   = W ./ (q0S .* M2);
    CD   = CD0 + k .* (CL.^2);
    Dpar = q0S .* CD0 .* M2;
    Dind = (k * W^2 ./ q0S) ./ M2;
    Dtot = Dpar + Dind;

    T = table(Mvec, CD0, CD, CL, round(Dpar,0), round(Dind,0), round(Dtot,0), ...
       'VariableNames',{'M','CD0_tot','CD','CL','D_par_lbf','D_ind_lbf','D_tot_lbf'});
end



% ============================================================
%   AIRCRAFT PERFORMANCE & DESIGN – PIPELINE ASIGNACIONES 1–4
% ============================================================
%
% 🔹 Propósito
% Este conjunto de funciones automatiza los cálculos de 
% performance (Asignaciones 1–4), permitiendo trabajar tanto
% con CD0 base constante como con la curva ΔCD0(M) digitalizada.
% Los módulos están diseñados para ejecutarse en cadena y 
% generar tablas, gráficas y resúmenes con explicación.
%
% 🔹 Flujo de ejecución principal (pipeline)
%
% run_airperf.m
%   └─> isa_std_atmos     → atm
%   └─> base_quantities   → base
%   └─> build_CD0_total   → CD0tot
%   └─> build_drag_table  → T
%   └─> check_mach_cap    → cap
%   └─> breguet_ER        → breg
%   └─> describe_airperf_outputs(atm, base, CD0tot, T, cap, breg)
%
% 🔹 Descripción de cada módulo
%
% isa_std_atmos(h_ft)
%   ENTRADA: altitud [ft]
%   SALIDA : atm struct con:
%       T_K, T_R, a_fts, rho, sigma
%   → Modelo de atmósfera estándar (ISA).
%
% base_quantities(atm, inputs)
%   ENTRADA: atm, struct inputs con {S, W, AR, e, TSFC, T_SL_tot}
%   SALIDA : base struct con:
%       q0, q0S, k, TSFC corregido
%   → Calcula magnitudes base aerodinámicas.
%
% build_CD0_total(M_grid, CD0_base, dCD0)
%   ENTRADA: malla Mach, CD0_base, curva ΔCD0(M)
%   SALIDA : CD0tot vector
%   → Construye la curva de arrastre parasitario.
%     (dos caminos: CD0_base constante o digitalización ΔCD0).
%
% build_drag_table(M_grid, CD0tot, base, inputs)
%   ENTRADA: Mach grid, CD0tot, base, inputs
%   SALIDA : tabla T con columnas:
%       M, C_D0, C_D, C_L, D_par, D_ind, D_tot
%   → Calcula arrastres parasitario, inducido y total.
%
% check_mach_cap(M_cap, CD0tot, base, inputs)
%   ENTRADA: Mach operativo
%   SALIDA : cap struct con:
%       C_D_cap, D_cap, T_avail
%   → Compara empuje disponible vs arrastre.
%     Determina si gobierna Mach límite o empuje.
%
% breguet_ER(inputs, base, atm)
%   ENTRADA: TSFC, (L/D), Wi/Wf, Mach operativo
%   SALIDA : breg struct con:
%       E (endurance), R (range)
%   → Implementa ecuaciones de Breguet.
%
% describe_airperf_outputs(atm, base, CD0tot, T, cap, breg)
%   ENTRADA: todos los structs anteriores
%   SALIDA : impresión en consola con unidades y explicación
%   → Resume y documenta resultados.
%
% 🔹 Notas de uso
% - Siempre arrancar desde run_airperf.m
% - Cada módulo puede probarse aislado llamando con sus argumentos.
% - Diseñado para Matlab Online con entrada/salida clara y
%   documentada para reportes técnicos en LaTeX.
%
% ============================================================
